function [ data_retrieve_outputcell] = data_retrieve_PMAnalyzer(data_retrieve_inputcell_pc, data_retrieve_inputcell_info, data_retrieve_inputcell_filt, handles)
%UNTITLED3 Summary of this function goes here
%   Detailed explanation goes here

% PC-data
Scores_TrialSubj  = data_retrieve_inputcell_pc{1};
EV                = data_retrieve_inputcell_pc{2}; %maybe needed in future...

% Subj, Trial, PC - information
PC_components_to_plot       = data_retrieve_inputcell_info{1};
trials_readin               = data_retrieve_inputcell_info{2};
subjects_readin             = data_retrieve_inputcell_info{3};
comp_selfdef_vars           = data_retrieve_inputcell_info{4};

%Filtering information
order             = data_retrieve_inputcell_filt{1}; % butterworth
cut_off_norm      = data_retrieve_inputcell_filt{2}; % butterworth
sample_frequency  = data_retrieve_inputcell_filt{3}; % sampling frequeency
look_at_pwelch    = data_retrieve_inputcell_filt{4}; % look powerspektrum
filter_PP         = data_retrieve_inputcell_filt{5}; % filteringoption
filter_PV         = data_retrieve_inputcell_filt{6}; % filteringoption
filter_PA         = data_retrieve_inputcell_filt{7}; % filteringoption






max_subj    = max(subjects_readin);
max_trial   = max(trials_readin);
nr_PC_total = length(EV);
cut_off     = cut_off_norm*sample_frequency/2;





% *******************************  %
%% ***** Initializing Data! ***** %%
% *******************************  %


% Variables Data Initialization
PP_TrialSubj = Scores_TrialSubj; % per definition
PV_TrialSubj = cell(max_trial,max_subj);
PA_TrialSubj = cell(max_trial,max_subj);


% Initialize specilized variables_TrialSubjPC
% % VarNames = {'Nr_Zeros_PP','Nr_Turns_PP','ZerosToTurnsRatio_PP', 'MeanTimeBetweenZeros_PP', 'STDTimeBetweenZeros_PP', 'mean_PP', 'std_PP', 'pos_mean_PP', 'pos_std_PP', 'neg_mean_PP', 'neg_std_PP';...
% %     'Nr_Zeros_PV','Nr_Turns_PV','ZerosToTurnsRatio_PV', 'MeanTimeBetweenZeros_PV', 'STDTimeBetweenZeros_PV', 'mean_PV', 'std_PV', 'pos_mean_PV', 'pos_std_PV', 'neg_mean_PV', 'neg_std_PV';...
% %     'Nr_Zeros_PA','Nr_Turns_PA','ZerosToTurnsRatio_PA', 'MeanTimeBetweenZeros_PA', 'STDTimeBetweenZeros_PA', 'mean_PA', 'std_PA', 'pos_mean_PA', 'pos_std_PA', 'neg_mean_PA', 'neg_std_PA';...
% %     };
% % PP_variables_TrialSubjPC(max_trial,max_subj,nr_PC_total) = struct(VarNames{1,1},[],VarNames{1,2},[],VarNames{1,3},[],VarNames{1,4},[],VarNames{1,5},[],VarNames{1,6},[],VarNames{1,7},[],VarNames{1,8},[],VarNames{1,9},[],VarNames{1,10},[],VarNames{1,11},[]);
% % PV_variables_TrialSubjPC(max_trial,max_subj,nr_PC_total) = struct(VarNames{2,1},[],VarNames{2,2},[],VarNames{2,3},[],VarNames{2,4},[],VarNames{2,5},[],VarNames{2,6},[],VarNames{2,7},[],VarNames{2,8},[],VarNames{2,9},[],VarNames{2,10},[],VarNames{2,11},[]);
% % PA_variables_TrialSubjPC(max_trial,max_subj,nr_PC_total) = struct(VarNames{3,1},[],VarNames{3,2},[],VarNames{3,3},[],VarNames{3,4},[],VarNames{3,5},[],VarNames{3,6},[],VarNames{3,7},[],VarNames{3,8},[],VarNames{3,9},[],VarNames{3,10},[],VarNames{3,11},[]);

% % InfoVarsComputed = {'Mean', 'std', 'MeanPos', 'MeanNeg', 'stdPos', 'stdNeg', ...
% %     'NoZC', 'NoP', 'stdTbZC', 'stdTbP', 'ratioZCP', ...
% %     'instantaneousPower', 'averagePower', 'RMS', ...
% %     'instantaneousActivity','averageActivity'};
% % 
% % PP_variables_TrialSubjPC(max_trial,max_subj,nr_PC_total) = cell2struct( cell(1, length(InfoVarsComputed)), InfoVarsComputed, 2 );
% % PV_variables_TrialSubjPC(max_trial,max_subj,nr_PC_total) = cell2struct( cell(1, length(InfoVarsComputed)), InfoVarsComputed, 2 );
% % PA_variables_TrialSubjPC(max_trial,max_subj,nr_PC_total) = cell2struct( cell(1, length(InfoVarsComputed)), InfoVarsComputed, 2 );
% % 
% % 

% *******************************  %
%% ***** Computing Data! ***** %%
% *******************************  %

% % % 
% % % 
% % % if length(PC_components_to_plot) > size(PP_TrialSubj{trial,subj}, 3)
% % %     msgbox('You chose to use more PCs for computation than columns available in data! This is not possible with PCA!', 'Error', 'Error')
% % %     error('\n\n\nYou chose to use more PCs for computation than columns available in data! This is not possible with PCA!\n\n\n')
% % % else
% % % end
% % % 


%% ***** Filter + Computation of principal velocity and aceleration *****
fprintf('\n\nCheck "Welch power spectral density estimate - figure" or fourier analysis to see if filtering options are accurate)')

% Power spectral density estimate of first trial first subject first pc
figure
[nonEmptyRows, nonEmptyCols] = find(~cellfun(@isempty,PP_TrialSubj));
pwelch(PP_TrialSubj{nonEmptyRows(1),nonEmptyCols(1)}(:,1),[],[],[],sample_frequency)
fprintf('\n        Welch-powerspektrum made of Subject 1, PC 1')
if look_at_pwelch
    fprintf('\n')
else
    fprintf('\n        Figure of Welch-powerspektrum closed\n')
    close gcf
end





fprintf('\n\nComputing PCA time-series (PP, PV, PA) and variables (rSTD, rVAR, CUM_rSTD, CUM_rVAR, selfdefined):\n')


if filter_PP == 1
    fprintf('\n      No filter used for PP!')
elseif filter_PP == 2
    fprintf('\n      Filtering PP - Default filtering option %d is chosen:', filter_PP)
    fprintf('\n          Butterworth filter used for PP --> Order = %d, cut_off %dHz for sample frequency %dHz   ...   ', order,cut_off, sample_frequency)
    
    [B,A] = butter(order,cut_off_norm); % 5th order lowpass with cutoff at cut_off_f 5Hz
    for trial = trials_readin
        for subj = subjects_readin
            for pc = 1:nr_PC_total
                PP_TrialSubj{trial,subj}(:, pc) = filtfilt(B,A,PP_TrialSubj{trial,subj}(:, pc));
            end
        end
    end
end
fprintf('done')




%% Velocities computation
if filter_PV == 1
    fprintf('\n\n      Computing PV. No filter!')
elseif filter_PV == 2
    fprintf('\n\n      Computing and filtering PV - Default filtering option %d is chosen:', filter_PV)
    fprintf('\n          Butterworth filter used for PV --> Order = %d, cut_off %dHz for sample frequency %dHz   ...   ', order,cut_off, sample_frequency)
elseif filter_PV == 3
    fprintf('\n          Other filter option not yet implemented!!!   No filtering done')
    filter_PV = 1;
end

for trial = trials_readin
    for subj = subjects_readin
        PV_TrialSubj{trial,subj} = zeros(size(PP_TrialSubj{trial,subj},1)-2,nr_PC_total);
        for pc = 1:nr_PC_total
            if filter_PV == 1
                PV_TrialSubj{trial,subj}(:, pc) = (sample_frequency/2)*diff_central(PP_TrialSubj{trial,subj}(:,pc));
            elseif filter_PV == 2
                PV_TrialSubj{trial,subj}(:, pc) = filtfilt(B,A,(sample_frequency/2)*diff_central(PP_TrialSubj{trial,subj}(:,pc)));
            end
        end
    end
end
fprintf('done')



%% Acelerations computation
if filter_PA == 1
    fprintf('\n\n      Computing PA. No filtering!')
elseif filter_PA == 2
    [B,A] = butter(order,cut_off_norm);
    fprintf('\n\n      Computing and filtering PA - Default filtering option %d is chosen:', filter_PA)
    fprintf('\n          Butterworth filter used for PA --> Order = %d, cut_off %dHz for sample frequency %dHz   ...   ', order,cut_off, sample_frequency)
elseif filter_PA == 3
    fprintf('\n          Other filter option not yet implemented!!!   No filtering done')
    filter_PA = 1;
end
for trial = trials_readin
    for subj = subjects_readin
        PA_TrialSubj{trial,subj} = zeros(size(PV_TrialSubj{trial,subj},1)-2,nr_PC_total);
        for pc = 1:nr_PC_total
            if filter_PA == 1
                PA_TrialSubj{trial,subj}(:, pc) = (sample_frequency/2)*diff_central(PV_TrialSubj{trial,subj}(:,pc));
            elseif filter_PA == 2
                PA_TrialSubj{trial,subj}(:, pc) = filtfilt(B,A,(sample_frequency/2)*diff_central(PV_TrialSubj{trial,subj}(:,pc)));
            end
        end
    end
end
fprintf('done')
%End ***** Filter + Computation of principal velocity and aceleration *****




%% ***** Fill "PP_variables_TrialSubjPC, PV_variables_TrialSubjPC, PA_variables_TrialSubjPC" *****


if comp_selfdef_vars
    fprintf('\n\n      Computing variables on PP, PV, PA :\n          std, mean, Nr_Turns, Nr_Zeros, ZerosToTurnsRatio, MeanTimeBetweenTurns, STDtimeBetweenZeros    ...   ')
    
    for trialPM = trials_readin
        for  subjPM = subjects_readin
            for pcPM = 1:nr_PC_total
                PP = PP_TrialSubj{trialPM, subjPM}(:,pcPM);
                PV = PV_TrialSubj{trialPM, subjPM}(:,pcPM);
                PA = PA_TrialSubj{trialPM, subjPM}(:,pcPM);
                
                % Compute the selfdefined variables (editable in function "optionsVariablesComp.m" in folder "FunctionsToEdit)
                [ PP_VarResults, PV_VarResults, PA_VarResults, InfoVarsComputed ] = optionsVariablesComp( PP, PV, PA, handles );
                
                handles.InfoVarsComputed = InfoVarsComputed;
                for varNr = 1:length(InfoVarsComputed)
                    PP_variables_TrialSubjPC(trialPM,subjPM,pcPM).(InfoVarsComputed(varNr).VarName) = PP_VarResults{varNr};
                    PV_variables_TrialSubjPC(trialPM,subjPM,pcPM).(InfoVarsComputed(varNr).VarName) = PV_VarResults{varNr};
                    PA_variables_TrialSubjPC(trialPM,subjPM,pcPM).(InfoVarsComputed(varNr).VarName) = PA_VarResults{varNr};
                end
            end % pcPM
        end % subjPM
    end % trialPM
    fprintf('done')
    
else
    fprintf('\n\n      Not Computing selfdefined variables on PP, PV, PA :\n          std, mean, Nr_Turns, Nr_Zeros, ZerosToTurnsRatio, MeanTimeBetweenTurns, STDtimeBetweenZeros    ...   ')
    
    PP_variables_TrialSubjPC(max_trial,max_subj,nr_PC_total) = struct('NoSelfdefinedVariablesComputed', [0]);
    PV_variables_TrialSubjPC(max_trial,max_subj,nr_PC_total) = struct('NoSelfdefinedVariablesComputed', [0]);
    PA_variables_TrialSubjPC(max_trial,max_subj,nr_PC_total) = struct('NoSelfdefinedVariablesComputed', [0]);
    
    InfoVarsComputed = struct('VarName', 'NoSelfdefinedVariablesComputed', 'VarFunctionHandle', 'NoHandles', 'ComputeVarYesOrNo', 'NoComputation');
end

fprintf('\n\n      Computing subject specific eigenvalues\n          rSTD, rVAR, CUM_rSTD, CUM_rVAR   ...   ')
%% Total Relative- and cumulative Eigenvalues of each subject for plots (not videos!)
PP_STD_TrialSubjPC      = zeros(max_trial, max_subj, nr_PC_total);
PP_rSTD_TrialSubjPC     = zeros(max_trial, max_subj, nr_PC_total);
PP_CUM_rSTD_TrialSubjPC = zeros(max_trial, max_subj, nr_PC_total);
PP_VAR_TrialSubjPC      = zeros(max_trial, max_subj, nr_PC_total);
PP_rVAR_TrialSubjPC     = zeros(max_trial, max_subj ,nr_PC_total);
PP_CUM_rVAR_TrialSubjPC = zeros(max_trial, max_subj, nr_PC_total);

PV_STD_TrialSubjPC       = zeros(max_trial, max_subj, nr_PC_total);
PV_rSTD_TrialSubjPC      = zeros(max_trial, max_subj, nr_PC_total);
PV_CUM_rSTD_TrialSubjPC  = zeros(max_trial, max_subj, nr_PC_total);
PV_VAR_TrialSubjPC       = zeros(max_trial, max_subj, nr_PC_total);
PV_rVAR_TrialSubjPC      = zeros(max_trial, max_subj, nr_PC_total);
PV_CUM_rVAR_TrialSubjPC  = zeros(max_trial, max_subj, nr_PC_total);

PA_STD_TrialSubjPC       = zeros(max_trial, max_subj, nr_PC_total);
PA_rSTD_TrialSubjPC      = zeros(max_trial, max_subj, nr_PC_total);
PA_CUM_rSTD_TrialSubjPC  = zeros(max_trial, max_subj, nr_PC_total);
PA_VAR_TrialSubjPC       = zeros(max_trial, max_subj, nr_PC_total);
PA_rVAR_TrialSubjPC      = zeros(max_trial, max_subj, nr_PC_total);
PA_CUM_rVAR_TrialSubjPC  = zeros(max_trial, max_subj, nr_PC_total);

% Prepare absolute values
for trial = trials_readin
    for subj = subjects_readin
        for pc = 1:nr_PC_total
            y_PP = PP_TrialSubj{trial, subj}(:,pc);
            y_PV = PV_TrialSubj{trial, subj}(:,pc);
            y_PA = PA_TrialSubj{trial, subj}(:,pc);
            
            PP_STD_TrialSubjPC(trial,subj,pc) = std(y_PP);
            PP_VAR_TrialSubjPC(trial,subj,pc) = (PP_STD_TrialSubjPC(trial,subj,pc))^2;
            
            PV_STD_TrialSubjPC(trial,subj,pc) = std(y_PV);
            PV_VAR_TrialSubjPC(trial,subj,pc) = (PV_STD_TrialSubjPC(trial,subj,pc))^2;
            
            PA_STD_TrialSubjPC(trial,subj,pc) = std(y_PA);
            PA_VAR_TrialSubjPC(trial,subj,pc) = (PA_STD_TrialSubjPC(trial,subj,pc))^2;
        end
        PP_total_STD = sum(PP_STD_TrialSubjPC,3);
        PP_total_VAR = sum(PP_VAR_TrialSubjPC,3);
        
        PV_total_STD = sum(PV_STD_TrialSubjPC,3);
        PV_total_VAR = sum(PV_VAR_TrialSubjPC,3);
        
        PA_total_STD = sum(PA_STD_TrialSubjPC,3);
        PA_total_VAR = sum(PA_VAR_TrialSubjPC,3);
    end
end

% Compute relative values
for trial = trials_readin
    for subj = subjects_readin
        PP_rSTD_TrialSubjPC(trial,subj,:) = 100*PP_STD_TrialSubjPC(trial,subj,:)/PP_total_STD(trial,subj);
        PP_rVAR_TrialSubjPC(trial,subj,:) = 100*PP_VAR_TrialSubjPC(trial,subj,:)/PP_total_VAR(trial,subj);
        
        PV_rSTD_TrialSubjPC(trial,subj,:) = 100*PV_STD_TrialSubjPC(trial,subj,:)/PV_total_STD(trial,subj);
        PV_rVAR_TrialSubjPC(trial,subj,:) = 100*PV_VAR_TrialSubjPC(trial,subj,:)/PV_total_VAR(trial,subj);
        
        PA_rSTD_TrialSubjPC(trial,subj,:) = 100*PA_STD_TrialSubjPC(trial,subj,:)/PA_total_STD(trial,subj);
        PA_rVAR_TrialSubjPC(trial,subj,:) = 100*PA_VAR_TrialSubjPC(trial,subj,:)/PA_total_VAR(trial,subj);
        
        for pc = 1:nr_PC_total
            PP_CUM_rSTD_TrialSubjPC(trial,subj,pc) = sum(PP_rSTD_TrialSubjPC(trial,subj,1:pc));
            PP_CUM_rVAR_TrialSubjPC(trial,subj,pc) = sum(PP_rVAR_TrialSubjPC(trial,subj,1:pc));
            
            PV_CUM_rSTD_TrialSubjPC(trial,subj,pc) = sum(PV_rSTD_TrialSubjPC(trial,subj,1:pc));
            PV_CUM_rVAR_TrialSubjPC(trial,subj,pc) = sum(PV_rVAR_TrialSubjPC(trial,subj,1:pc));
            
            PA_CUM_rSTD_TrialSubjPC(trial,subj,pc) = sum(PA_rSTD_TrialSubjPC(trial,subj,1:pc));
            PA_CUM_rVAR_TrialSubjPC(trial,subj,pc) = sum(PA_rVAR_TrialSubjPC(trial,subj,1:pc));
        end
    end
end
fprintf('done')



% Sort and name output variables
TimeSeries.PP_TrialSubj = PP_TrialSubj;
TimeSeries.PV_TrialSubj = PV_TrialSubj;
TimeSeries.PA_TrialSubj = PA_TrialSubj;


VariablesEigenvalues.PP_rSTD_TrialSubjPC = PP_rSTD_TrialSubjPC;
VariablesEigenvalues.PP_rVAR_TrialSubjPC = PP_rVAR_TrialSubjPC;
VariablesEigenvalues.PP_CUM_rSTD_TrialSubjPC = PP_CUM_rSTD_TrialSubjPC;
VariablesEigenvalues.PP_CUM_rVAR_TrialSubjPC = PP_CUM_rVAR_TrialSubjPC;

VariablesEigenvalues.PV_rSTD_TrialSubjPC = PV_rSTD_TrialSubjPC;
VariablesEigenvalues.PV_rVAR_TrialSubjPC = PV_rVAR_TrialSubjPC;
VariablesEigenvalues.PV_CUM_rSTD_TrialSubjPC = PV_CUM_rSTD_TrialSubjPC;
VariablesEigenvalues.PV_CUM_rVAR_TrialSubjPC = PV_CUM_rVAR_TrialSubjPC;

VariablesEigenvalues.PA_rSTD_TrialSubjPC = PA_rSTD_TrialSubjPC;
VariablesEigenvalues.PA_rVAR_TrialSubjPC = PA_rVAR_TrialSubjPC;
VariablesEigenvalues.PA_CUM_rSTD_TrialSubjPC = PA_CUM_rSTD_TrialSubjPC;
VariablesEigenvalues.PA_CUM_rVAR_TrialSubjPC = PA_CUM_rVAR_TrialSubjPC;


VariablesSelfdefined.PP_variables_TrialSubjPC = PP_variables_TrialSubjPC;
VariablesSelfdefined.PV_variables_TrialSubjPC = PV_variables_TrialSubjPC;
VariablesSelfdefined.PA_variables_TrialSubjPC = PA_variables_TrialSubjPC;



%% Output
data_retrieve_outputcell{1}  = handles;
data_retrieve_outputcell{2}  = TimeSeries;
data_retrieve_outputcell{3}  = VariablesEigenvalues;
data_retrieve_outputcell{4}  = VariablesSelfdefined;
data_retrieve_outputcell{5}  = InfoVarsComputed;


% Variables - Data
% % data_retrieve_outputcell{1}  = PP_TrialSubj;
% % data_retrieve_outputcell{2}  = PV_TrialSubj;
% % data_retrieve_outputcell{3}  = PA_TrialSubj;
% %
% % data_retrieve_outputcell{4}  = PP_variables_TrialSubjPC;
% % data_retrieve_outputcell{5}  = PV_variables_TrialSubjPC;
% % data_retrieve_outputcell{6}  = PA_variables_TrialSubjPC;



% data_retrieve_outputcell{8}  = rVAR_TrialSubjPC;
% data_retrieve_outputcell{9}  = CUM_rSTD_TrialSubjPC;
% data_retrieve_outputcell{10} = CUM_rVAR_TrialSubjPC;
%
% data_retrieve_outputcell{11}  = PV_rSTD_TrialSubjPC;
% data_retrieve_outputcell{12}  = PV_rVAR_TrialSubjPC;
% data_retrieve_outputcell{13}  = PV_CUM_rSTD_TrialSubjPC;
% data_retrieve_outputcell{14}  = PV_CUM_rVAR_TrialSubjPC;
%
% data_retrieve_outputcell{15}  = PA_rSTD_TrialSubjPC;
% data_retrieve_outputcell{16}  = PA_rVAR_TrialSubjPC;
% data_retrieve_outputcell{17}  = PA_CUM_rSTD_TrialSubjPC;
% data_retrieve_outputcell{18}  = PA_CUM_rVAR_TrialSubjPC;


end
